﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Shapes;

namespace Gebrauchtbootsverkauf
{
    /// <summary>
    /// Interaction logic for bootsAngebot.xaml
    /// </summary>
    public partial class BootsAngebot : Window
    {

        // mehrfach brauchbare Methode deklarieren:
        // hier werden nämlich die Detaildaten zum gewählten (aktiven) Boot aus dem Grid angezeigt -> Code nur 1x geschrieben, in (hier) 2 Handlern verwendet

        private void display_details() 
        {

            Boot gew_Boot = offerGrid.SelectedItem as Boot; // aktives / gewähltes Boot aus dem Angebotsgrid holen

            // Dialog mit Details zum Boot anhand der entsprechenden Auswahl laden, Daten übergeben und anzeigen
            // ACHTUNG: DAU-Sicherung -> wenn User auf Anzeigen drückt, obwohl er (noch) nichts gewählt ist, kommt ein Null-Objekt mit Abbruch
            // -> Abfangen mit try / catch-Konstrukt

            try
            {
                BootsDetails bootsDetails = new BootsDetails                               (gew_Boot);
                bootsDetails.Owner =                                                             this;
                bootsDetails.WindowStartupLocation = System.Windows.WindowStartupLocation.CenterOwner;
                bootsDetails.ShowDialog                                                            ();
            }
            catch
            {
                // Anzeigeaktion beenden - wenn es dem DAU zu blöd wird, wird der schon was wählen...                
                if (gew_Boot == null)                                                                                                         // NULL-Reference-Exception?
                    {
                    MessageBox.Show("Bitte wählen Sie erst aus unserem reichhaltigen Angebut aus und noch besser KAUFEN SIE ETWAS!!!!!!!!!"); // ja -> zumindest Meldung machen...
                    return                                                                                                                  ; // Routinen-Feierabend an der Stelle
                    }
            }

        }

        public BootsAngebot(string dlg_title, Object[] AR_ships) // Feld mit Schiffen übergeben, zu denen man Details erhalten kann
        {
            InitializeComponent           (); // Vorgaberoutine
            this.Title = dlg_title          ; // Fenstertitel setzen (je nach übergebener Untergruppe)
            offerGrid.ItemsSource = AR_ships; // die Schiffsdaten ins Angebotgrid übertragen
        }

        private void dblClick(object sender, MouseButtonEventArgs e)
        {
            display_details(); // Methode zum Anzeigen der Boots-Details aufrufen (sender und e wird nicht gebraucht...)
        }

        private void Anz_Click(object sender, RoutedEventArgs e)
        {
            display_details(); // Methode zum Anzeigen der Boots-Details aufrufen (sender und e wird nicht gebraucht...)
        }

    }
}